import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:get/get.dart';
import 'package:viserpay_merchant/data/model/invoice/invoice_history_response_model.dart';
import 'package:viserpay_merchant/data/services/api_service.dart';
import 'package:viserpay_merchant/view/screens/withdrawals/withdraw_history/widget/status_widget.dart';

import '../../../../../core/helper/date_converter.dart';
import '../../../../../core/helper/string_format_helper.dart';
import '../../../../../core/route/route.dart';
import '../../../../../core/utils/dimensions.dart';
import '../../../../../core/utils/my_color.dart';
import '../../../../../core/utils/my_strings.dart';
import '../../../../../core/utils/style.dart';
import '../../../../../data/controller/invoice/invoice_history_controller.dart';
import '../../../../components/bottom-sheet/bottom_sheet_close_button.dart';
import '../../../../components/bottom-sheet/bottom_sheet_header_row.dart';
import '../../../../components/divider/custom_divider.dart';
import '../../../../components/snack_bar/show_custom_snackbar.dart';
import '../../../../components/text/bottom_sheet_header_text.dart';
import 'invoice_action_button.dart';

class InvoicesBottomSheet {
  static void bottomSheet(BuildContext context, int index, {required InvoiceDataModel invoiceDataModel}) {
    showModalBottomSheet(
        isScrollControlled: true,
        backgroundColor: MyColor.transparentColor,
        context: context,
        builder: (context) => GetBuilder<InvoiceHistoryController>(
              builder: (controller) => SingleChildScrollView(
                physics: const ClampingScrollPhysics(),
                child: Container(
                  padding: const EdgeInsets.symmetric(horizontal: Dimensions.space15, vertical: Dimensions.space20),
                  width: MediaQuery.of(context).size.width,
                  decoration: BoxDecoration(color: MyColor.getCardBgColor(), borderRadius: const BorderRadius.vertical(top: Radius.circular(15))),
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: [
                    const BottomSheetHeaderRow(
                      header: MyStrings.invoiceDetails,
                      bottomSpace: 0,
                    ),
                    const SizedBox(height: Dimensions.space20),

                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              MyStrings.invoicesTo.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            Text(
                              invoiceDataModel.user?.getDisplayName() ?? "",
                              style: regularDefault.copyWith(color: MyColor.getTextColor()),
                            )
                          ],
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.end,
                          children: [
                            Text(
                              MyStrings.date.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            Text(
                              DateConverter.isoStringToLocalDateOnly(invoiceDataModel.createdAt ?? ""),
                              style: regularDefault.copyWith(color: MyColor.getTextColor()),
                            )
                          ],
                        )
                      ],
                    ),
                    const SizedBox(height: Dimensions.space15),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              MyStrings.email.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            Text(
                              invoiceDataModel.user?.email ?? "",
                              style: regularDefault.copyWith(color: MyColor.getTextColor()),
                            )
                          ],
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.end,
                          children: [
                            Text(
                              MyStrings.amount.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            Text(
                              "${Get.find<ApiClient>().getCurrencyOrUsername(isSymbol: true)}${StringConverter.formatNumber(
                                invoiceDataModel.totalAmount ?? "0",
                              )}",
                              style: regularDefault.copyWith(color: MyColor.getTextColor(), fontWeight: FontWeight.w600),
                            ),
                          ],
                        ),
                      ],
                    ),
                    const SizedBox(height: Dimensions.space15),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              MyStrings.phone.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            Text(
                              "+${invoiceDataModel.user!.getPhoneNumber()}",
                              style: regularDefault.copyWith(color: MyColor.getTextColor()),
                            )
                          ],
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.end,
                          children: [
                            Text(
                              MyStrings.paymentStatus.tr,
                              style: regularSmall.copyWith(color: MyColor.getTextColor().withOpacity(0.6)),
                            ),
                            const SizedBox(height: Dimensions.space5),
                            StatusWidget(
                              status: controller.getStatusOrColor(index),
                              color: controller.getStatusOrColor(index, isStatus: false),
                            )
                          ],
                        )
                      ],
                    ),

                    //user can edit only unpublished invoice
                    if (invoiceDataModel.status == "0") ...[
                      const CustomDivider(space: Dimensions.space15),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Expanded(
                            child: InVoiceActionButton(
                              press: () {
                                Get.back();
                                Get.toNamed(RouteHelper.updateInvoiceScreen, arguments: [invoiceDataModel.id, invoiceDataModel.totalAmount, controller.model.data?.paymentCharge as PaymentCharge])?.then((value) {
                                  if (value != null && value == 'success') {
                                    controller.initialData();
                                  }
                                });
                              },
                              text: MyStrings.edit.tr,
                              bgColor: MyColor.primaryColor,
                              iconData: Icons.edit,
                            ),
                          )
                        ],
                      )
                    ],

                    const SizedBox(
                      height: Dimensions.space10,
                    ),
                    InVoiceActionButton(
                      press: () {
                        controller.downloadINVOICE(invoiceDataModel.id.toString());
                      },
                      text: controller.downloadLoading ? "${MyStrings.downloading.tr}..." : MyStrings.download.tr,
                      bgColor: MyColor.colorOrange,
                      iconData: Icons.download_for_offline_rounded,
                    ),
                  ]),
                ),
              ),
            ));
  }
}
